/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.itemgroup.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import io.wispforest.owo.itemgroup.Icon;
import io.wispforest.owo.itemgroup.OwoItemGroup;
import io.wispforest.owo.itemgroup.gui.ItemGroupButton;
import io.wispforest.owo.itemgroup.gui.ItemGroupTab;
import io.wispforest.owo.itemgroup.json.WrapperGroup;
import io.wispforest.owo.moddata.ModDataConsumer;
import io.wispforest.owo.util.pond.OwoItemExtensions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class OwoItemGroupLoader
implements ModDataConsumer {
    public static final OwoItemGroupLoader INSTANCE = new OwoItemGroupLoader();
    private static final Map<String, JsonObject> BUFFERED_GROUPS = new HashMap<String, JsonObject>();

    private OwoItemGroupLoader() {
    }

    public static class_1761 onGroupCreated(class_1761 group) {
        if (!BUFFERED_GROUPS.containsKey(group.method_7751())) {
            return null;
        }
        return INSTANCE.loadGroup(BUFFERED_GROUPS.remove(group.method_7751()));
    }

    @Override
    public void acceptParsedFile(class_2960 id, JsonObject json) {
        this.loadGroup(json);
    }

    protected class_1761 loadGroup(JsonObject json) {
        String targetGroupId = class_3518.method_15265((JsonObject)json, (String)"target_group");
        class_1761 searchGroup = null;
        for (class_1761 group : class_1761.field_7921) {
            if (!group.method_7751().equals(targetGroupId)) continue;
            searchGroup = group;
            break;
        }
        if (searchGroup == null) {
            BUFFERED_GROUPS.put(targetGroupId, json);
            return null;
        }
        class_1761 targetGroup = searchGroup;
        JsonArray tabsArray = class_3518.method_15292((JsonObject)json, (String)"tabs", (JsonArray)new JsonArray());
        ArrayList<ItemGroupTab> tabs = new ArrayList<ItemGroupTab>();
        tabsArray.forEach(jsonElement -> {
            if (!jsonElement.isJsonObject()) {
                return;
            }
            JsonObject tabObject = jsonElement.getAsJsonObject();
            class_2960 texture = new class_2960(class_3518.method_15253((JsonObject)tabObject, (String)"texture", (String)ItemGroupTab.DEFAULT_TEXTURE.toString()));
            class_6862 tag = class_6862.method_40092((class_5321)class_2378.field_25108, (class_2960)new class_2960(class_3518.method_15265((JsonObject)tabObject, (String)"tag")));
            class_1792 icon = (class_1792)class_2378.field_11142.method_10223(new class_2960(class_3518.method_15265((JsonObject)tabObject, (String)"icon")));
            String name = class_3518.method_15265((JsonObject)tabObject, (String)"name");
            tabs.add(new ItemGroupTab(Icon.of((class_1935)icon), OwoItemGroup.ButtonDefinition.tooltipFor(targetGroup, "tab", name), stacks -> class_2378.field_11142.method_10220().filter(item -> item.method_40131().method_40220(tag)).map(class_1792::method_7854).forEach(arg_0 -> stacks.add(arg_0)), texture, false));
        });
        JsonArray buttonsArray = class_3518.method_15292((JsonObject)json, (String)"buttons", (JsonArray)new JsonArray());
        ArrayList<ItemGroupButton> buttons = new ArrayList<ItemGroupButton>();
        buttonsArray.forEach(jsonElement -> {
            if (!jsonElement.isJsonObject()) {
                return;
            }
            JsonObject buttonObject = jsonElement.getAsJsonObject();
            String link = class_3518.method_15265((JsonObject)buttonObject, (String)"link");
            String name = class_3518.method_15265((JsonObject)buttonObject, (String)"name");
            int u = class_3518.method_15260((JsonObject)buttonObject, (String)"texture_u");
            int v = class_3518.method_15260((JsonObject)buttonObject, (String)"texture_v");
            int textureWidth = class_3518.method_15282((JsonObject)buttonObject, (String)"texture_width", (int)64);
            int textureHeight = class_3518.method_15282((JsonObject)buttonObject, (String)"texture_height", (int)64);
            String textureId = class_3518.method_15253((JsonObject)buttonObject, (String)"texture", null);
            class_2960 texture = textureId == null ? ItemGroupButton.ICONS_TEXTURE : new class_2960(textureId);
            buttons.add(ItemGroupButton.link(Icon.of(texture, u, v, textureWidth, textureHeight), name, link));
        });
        if (targetGroup instanceof WrapperGroup) {
            WrapperGroup wrapper = (WrapperGroup)targetGroup;
            wrapper.addTabs(tabs);
            wrapper.addButtons(buttons);
            if (class_3518.method_15258((JsonObject)json, (String)"extend", (boolean)false)) {
                wrapper.markExtension();
            }
            return wrapper;
        }
        WrapperGroup wrapper = new WrapperGroup(targetGroup, tabs, buttons);
        wrapper.initialize();
        if (class_3518.method_15258((JsonObject)json, (String)"extend", (boolean)false)) {
            wrapper.markExtension();
        }
        class_2378.field_11142.method_10220().filter(item -> item.method_7859() == targetGroup).forEach(item -> ((OwoItemExtensions)item).owo$setGroup(targetGroup));
        return wrapper;
    }

    @Override
    public String getDataSubdirectory() {
        return "item_group_tabs";
    }
}

